<?php

/**
 * LoginInfo
 *
 * Plugin to add a customized info to the login screen
 *
 * @version 1.2
 * @author Markus Neubauer
 * @http://www.std-soft.com/bfaq/52-cat-webmail/107-text-auf-der-login-seite-einblenden.html
 * @example: https://www.std-soft.de/webmail (source)
 */
class login_info extends rcube_plugin
{
    // only task 'login'
    public $task = 'login';
    // we've got no ajax handlers
    public $noajax = true;
    // skip frames
    public $noframe = true;
                        
	function init()
	{
		$this->add_hook('template_object_loginform', array($this, 'add_login_info'));
	}

	public function add_login_info($arg)
	{
		$rcmail = rcmail::get_instance();
		$this->load_config();

		if ( $rcmail->config->get('login_info') ) 
			$rcmail->output->add_footer( $rcmail->config->get('login_info') );
				
		return $arg;
	}
}

?>
