<?php
/**
 * plugins/qmailadmin_login/qmlogin.php - Provides qmailadmin login form
 *
 * Copyright (c) 2004-2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail QmailAdmin Login plugin.
 *
 * QmailAdmin Login plugin is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * QmailAdmin Login plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QmailAdmin Login plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: qmlogin.php,v 1.6 2005/07/27 16:08:20 tokul Exp $
 * @package sm-plugins
 * @subpackage qmailadmin_login
 */

/**
 * make sure SM_PATH is defined
 * @ignore
 */
define('SM_PATH','../../');

// load required files
include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/forms.php');
// add sqm_baseuri function
include_once(SM_PATH . 'functions/display_messages.php');
// add plugins functions and config
include_once(SM_PATH . 'plugins/qmailadmin_login/functions.php');

global $color, $domain, $username;

// extract username and domain
if (preg_match("/^(.+)@(.+)/",$username,$qmlogin_match)) {
    $qmlogin_username=$qmlogin_match[1];
    $qmlogin_domain=$qmlogin_match[2];
} else {
    $qmlogin_username=$username;
    $qmlogin_domain=$domain;
}

displayPageHeader($color,'none');

bindtextdomain('qmailadmin_login', SM_PATH . 'locale');
textdomain('qmailadmin_login');

echo '<h3 align="center">' . _("Account Administration") . "</h3>\n";
echo '<div align="center">';
// cgi operations are not monitored by interface
echo "<p><small><font color=\"$color[2]\"><b>" 
    ._("WARNING: You will have to relogin into SquirrelMail, if you change your password.")
    ."</b></font></small></p>\n";

echo '<iframe name="qmailadmin" width="95%" height="100%"'
    .'frameborder="' . ($qmlogin_frameborder ? 1 : 0) .'"'
    .'src="' . sqm_baseuri() . "plugins/qmailadmin_login/qmlogin_iframe.php\">";
// form for browsers without iframe support
qmlogin_login_form($qmlogin_cgi_url,$qmlogin_username,$qmlogin_domain);
// close iframe
echo "</iframe>\n";

// TODO: add domain administration form here
echo "</div>";
//bindtextdomain('squirrelmail', SM_PATH . 'locale');
//textdomain('squirrelmail');
?>
</body></html>