<?php
/**
 * plugins/qmailadmin_login/qmlogin_iframe.php - Provides qmailadmin login form
 *
 * Copyright (c) 2004-2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail QmailAdmin Login plugin.
 *
 * QmailAdmin Login plugin is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * QmailAdmin Login plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QmailAdmin Login plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: qmlogin_iframe.php,v 1.4 2005/06/26 09:12:56 tokul Exp $
 * @package sm-plugins
 * @subpackage qmailadmin_login
 */

/**
 * make sure SM_PATH is defined
 * @ignore
 */
define('SM_PATH','../../');

// load required files
include_once(SM_PATH . 'include/validate.php');
include_once(SM_PATH . 'functions/forms.php');
include_once(SM_PATH . 'plugins/qmailadmin_login/functions.php');

global $color, $domain, $username;

// extract username and domain
if (preg_match("/^(.+)@(.+)/",$username,$qmlogin_match)) {
    $qmlogin_username=$qmlogin_match[1];
    $qmlogin_domain=$qmlogin_match[2];
} else {
    $qmlogin_username=$username;
    $qmlogin_domain=$domain;
}

if ($qmlogin_autologin) {
    sqgetGlobalVar('key', $key, SQ_COOKIE);
    sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);
    $qmlogin_passwd = OneTimePadDecrypt($key, $onetimepad);

    header('Location: '.$qmlogin_cgi_url.'?username='.$qmlogin_username
           .'&domain='.$qmlogin_domain.'&password='.$qmlogin_passwd);

    bindtextdomain('qmailadmin_login', SM_PATH . 'locale');
    textdomain('qmailadmin_login');

    $extra="<meta http-equiv=\"refresh\" content=\"2;url="
        .$qmlogin_cgi_url.'?username='.$qmlogin_username.'&amp;domain='
        .$qmlogin_domain.'&amp;password='.$qmlogin_passwd."\">\n";

    displayHtmlHeader(_("Redirecting to QmailAdmin"),$extra,false);

    echo "<body text=\"$color[8]\" bgcolor=\"$color[4]\" link=\"$color[7]\" vlink=\"$color[7]\" alink=\"$color[7]\">\n";

    echo '<p>' ._("Your are being redirected to the administration page. If your browser does not automatically redirect you, please click on login button.")."</p>\n";

    echo addForm($qmlogin_cgi_url)
        .addHidden('username',$qmlogin_username)
        .addHidden('domain',$qmlogin_domain)
        .addHidden('password',$qmlogin_passwd)
        .addSubmit(_("Login"))
        ."</form>";
} else {
    displayHtmlHeader();
    echo "<body text=\"$color[8]\" bgcolor=\"$color[4]\" link=\"$color[7]\" vlink=\"$color[7]\" alink=\"$color[7]\">\n";

    bindtextdomain('qmailadmin_login', SM_PATH . 'locale');
    textdomain('qmailadmin_login');

    qmlogin_login_form($qmlogin_cgi_url,$qmlogin_username,$qmlogin_domain);

    // TODO: add domain administration form here

    // bindtextdomain('squirrelmail', SM_PATH . 'locale');
    // textdomain('squirrelmail');
}
?>
</body></html>